/*
	File:		RadioGroup.h

	Contains:	Radio Group class.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#pragma once

#include <Controls.h>

class RadioGroup
{
	public:
			RadioGroup();
		virtual ~RadioGroup();
		
		virtual void		AddControl( ControlRef control, SInt16 value );
		virtual SInt16		GetValue();
		virtual void		SetValue( SInt16 value );
		virtual void		SetMixed( SInt16 value );
		virtual void		SetValueByControl( ControlRef control );
		
	private:
		SInt16				fValue;
		Handle				fInfo;
		Boolean				fMixed;
};